<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * App\Entity\Model\ItemPago
 *
 * @ORM\Entity(repositoryClass="App\Repository\ItemRepository")
 */
class ItemPago
{

    /**
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id;

    /**
     * @ORM\Column(nullable=true)
     */
    private  $name;

    /**
     * @var decimal $valor
     *
     * @ORM\Column(type="decimal", precision=15, scale=2)
     */
    private $valor;


    /**
     * @ORM\Column()
     */
    private  $tiempo;

    /**
     * @ORM\Column(name="plazo", type="integer", nullable=true)
     */
    private  $plazo;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\FormaPago")
     * @ORM\JoinColumn(name="formapago_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $formapago;

    /**
     *
     * @ORM\ManyToMany(targetEntity="App\Entity\Model\Invoice", mappedBy="pagos")
     */
    protected $invoices;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return decimal
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * @param decimal $valor
     */
    public function setValor($valor)
    {
        $this->valor = $valor;
    }

    /**
     * @return string
     */
    public function getTiempo()
    {
        return $this->tiempo;
    }

    /**
     * @param string $tiempo
     */
    public function setTiempo($tiempo)
    {
        $this->tiempo = $tiempo;
    }

    /**
     * @return int
     */
    public function getPlazo()
    {
        return $this->plazo;
    }

    /**
     * @param int $plazo
     */
    public function setPlazo($plazo)
    {
        $this->plazo = $plazo;
    }

    /**
     * @return \App\Entity\Model\FormaPago
     */
    public function getFormapago()
    {
        return $this->formapago;
    }

    /**
     * @param mixed $formapago
     */
    public function setFormapago($formapago)
    {
        $this->formapago = $formapago;
    }

}
