<?php

namespace App\Entity\Model;

use App\Util\ValidarIdentificacion;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 *
 * @ORM\Table(name="pago_empresa")
 * @ORM\Entity(repositoryClass="App\Repository\PagoEmpresaRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class PagoEmpresa
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="slug", type="string", length=32, nullable=true, unique=true)
     */
    private $slug;

    /**
     * @var string
     *
     * @ORM\Column(name="numerocomprobante", type="string", length=200)
     * @Assert\NotBlank(message = "Ingrese el numero")
     */
    private $numerocomprobante;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Empresa")
     * @ORM\JoinColumn(name="empresa_id", referencedColumnName="id", onDelete="SET NULL")
     * @Assert\NotBlank(allowNull=false, message="empresa no puede ser nulo, corregir en codigo fuente")
     */
    private $empresa;

    /**
     * @var string $valor
     *
     * @ORM\Column(name="valor", type="decimal", scale=2, precision=15, nullable=true)
     */
    private $valor;

    /**
     * @var boolean $closed
     *
     * @ORM\Column(name="cerrado", type="boolean", nullable=true)
     */
    private $cerrado;

    /**
     * @var date $create_date
     *
     * @ORM\Column(name="create_date", type="date", nullable=true)
     */
    private $create_date;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $mes;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $anio;

    /**
     * @var date $fecha_acreditacion
     *
     * @ORM\Column(name="fecha_acreditacion", type="date", nullable=true)
     */
    private $fecha_acreditacion;

    /**
     * PagoEmpresa constructor.
     */
    public function __construct()
    {
        $this->create_date = new \DateTime();
        $this->cerrado = false;
    }

    /**
     * @ORM\PrePersist
     */
    public function setSlug()
    {
        $this->slug = md5('sv_'.$this->empresa->getId().uniqid());
    }
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    public function jsonSerialize()
    {
        return array(
            'id' => $this->getId(),

        );
    }

    public function label()
    {
        return $this->getNumerocomprobante();
    }


    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa)
    {
        $this->empresa = $empresa;
    }

    /**
     * @return string
     */
    public function getSlug(): string
    {
        return $this->slug;
    }

    /**
     * @return string
     */
    public function getNumerocomprobante()
    {
        return $this->numerocomprobante;
    }

    /**
     * @param string $numerocomprobante
     */
    public function setNumerocomprobante($numerocomprobante)
    {
        $this->numerocomprobante = $numerocomprobante;
    }



    /**
     * @return string
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * @param string $valor
     */
    public function setValor($valor)
    {
        $this->valor = $valor;
    }

    /**
     * @return bool
     */
    public function isCerrado()
    {
        return $this->cerrado;
    }

    /**
     * @param bool $cerrado
     */
    public function setCerrado($cerrado): void
    {
        $this->cerrado = $cerrado;
    }


    /**
     * @return date
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * @param date $create_date
     */
    public function setCreateDate($create_date)
    {
        $this->create_date = $create_date;
    }

    /**
     * @return int
     */
    public function getMes(): int
    {
        return $this->mes;
    }

    /**
     * @param int $mes
     */
    public function setMes(int $mes): void
    {
        $this->mes = $mes;
    }

    /**
     * @return int
     */
    public function getAnio(): int
    {
        return $this->anio;
    }

    /**
     * @param int $anio
     */
    public function setAnio(int $anio): void
    {
        $this->anio = $anio;
    }

    /**
     * @return date
     */
    public function getFechaAcreditacion()
    {
        return $this->fecha_acreditacion;
    }

    /**
     * @param date $fecha_acreditacion
     */
    public function setFechaAcreditacion($fecha_acreditacion): void
    {
        $this->fecha_acreditacion = $fecha_acreditacion;
    }


}
