<?php

namespace App\Entity\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * TransporteSocio
 *
 * @ORM\Table(name="transporte_socio", uniqueConstraints={@ORM\UniqueConstraint(name="transportesocio_unique", columns={
 *     "ptoemisionsocio","empresa_id"})}
 *     )
 * @ORM\Entity(repositoryClass="App\Repository\TransporteSocioRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class TransporteSocio
{

    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id = null;

    /**
     * @ORM\Column(name="slug", type="string", length=32, nullable=true, unique=true)
     */
    private  $slug = null;

    /**
     * @var string
     * @ORM\Column(type="string", length=3, nullable=false)
     */
    private $ptoemisionsocio;

    /**
     * @var string
     * @ORM\Column(type="string", nullable=false, length=15, unique=true)
     */
    private $rucsocio;

    /**
     * @var string
     * @ORM\Column(type="string", length=100, nullable=false)
     */
    private $nombresocio;

    /**
     * @var string
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private $tpcontribuyentesocio;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Model\PlacasSocios", cascade={"all"}, mappedBy="transportesocio", orphanRemoval=true)
     */
    private $placas;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Empresa")
     * @ORM\JoinColumn(name="empresa_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $empresa;

    /**
     * @var boolean
     *
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $enabled;

//    /**
//     *
//     * @ORM\Column(name="email", type="string", length=191)
//     * @Assert\NotBlank(message = "Ingrese el correo electrónico")
//     * @Assert\Email()
//     */
//    private  $email = null;
//
//    /**
//     *
//     * @ORM\Column(name="password", type="string", length=20)
//     * @Assert\NotBlank(message = "Ingrese el password")
//     */
//    private  $password = null;

    /**
     * @var boolean
     *
     */
    private $estransportista;

    private $eliminados=[];


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function __construct()
    {
        $this->placas = new ArrayCollection();
        $this->estransportista = false;
        $this->enabled = true;
    }

    /**
     * @ORM\PrePersist
     */
    public function setSlug()
    {
        $this->slug = md5('sv_' . $this->empresa->getId() . $this->empresa->getRuc() . $this->rucsocio);
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPlacas()
    {
        return $this->placas;
    }

    /**
     * Add items
     *
     * @param App\Entity\Model\PlacasSocio $placa
     */
    public function addPlaca(PlacasSocios $placa)
    {
        $this->placas[] = $placa;
    }

    /**
     * @return string
     */
    public function getPtoemisionsocio()
    {
        return $this->ptoemisionsocio;
    }

    /**
     * @param string $ptoemisionsocio
     */
    public function setPtoemisionsocio($ptoemisionsocio)
    {
        $this->ptoemisionsocio = $ptoemisionsocio;
    }

    /**
     * @return string
     */
    public function getRucsocio()
    {
        return $this->rucsocio;
    }

    /**
     * @param string $rucsocio
     */
    public function setRucsocio($rucsocio)
    {
        $this->rucsocio = $rucsocio;
    }

    /**
     * @return string
     */
    public function getNombresocio()
    {
        return $this->nombresocio;
    }

    /**
     * @param string $nombresocio
     */
    public function setNombresocio($nombresocio)
    {
        $this->nombresocio = $nombresocio;
    }

    /**
     * @return string
     */
    public function getTpcontribuyentesocio()
    {
        return $this->tpcontribuyentesocio;
    }

    /**
     * @param string $tpcontribuyentesocio
     */
    public function setTpcontribuyentesocio($tpcontribuyentesocio)
    {
        $this->tpcontribuyentesocio = $tpcontribuyentesocio;
    }

    /**
     * @return bool
     */
    public function getEstransportista()
    {
        return $this->estransportista;
    }

    /**
     * @param bool $estransportista
     */
    public function setEstransportista($estransportista)
    {
        $this->estransportista = $estransportista;
    }

    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa): void
    {
        $this->empresa = $empresa;
    }


    /**
     * @return array
     */
    public function getEliminados(): array
    {
        return $this->eliminados;
    }



    /** ** RELATIONSHIPS ** */


    /**
     * removeItem
     * removes an item and recalculcates amounts
     *
     * @param mixed $mixed : can be an integer or an item instance
     *                       - if an integer, removes the item with
     *                         that position in the collection
     *                       - if an instance, removes that item
     * @author JoeZ99 <jzarate@gmail.com>
     */
    public function removePlaca($mixed)
    {
        if ($mixed instanceof PlacasSocios) {
            $items = $this->getPlacas();
            foreach ($items as $ref => $item) {
                if ($item === $mixed) {
                    unset($items[$ref]);
                    $this->eliminados[]=$item;
                    break;
                }
            }
        } elseif (is_int($mixed)) {
            unset($this->placas[$mixed]);
            $this->eliminados = $this->placas[$mixed];
        }
    }

    /** *********** LIFECYCLE CALLBACKS ************* */

    /**
     * @ORM\PreUpdate
     * @ORM\PrePersist
     */
    public function preSave(LifecycleEventArgs $args)
    {
        foreach ($this->getPlacas() as $placa) {
            //$placa = new  PlacasSocios();
            $placa->setTransportesocio($this);
        }

    }

    /**
     * @return bool
     */
    public function getEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled(bool $enabled): void
    {
        $this->enabled = $enabled;
    }

    /**
     * @return string|null
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string|null $email
     */
    public function setEmail( $email): void
    {
        $this->email = $email;
    }

    /**
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string|null $password
     */
    public function setPassword( $password): void
    {
        $this->password = $password;
    }


}
