<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PlanType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'tax.form.name',
                'attr' => ['class'=>'sv_uppercase'],
                'translation_domain' => 'core',
            ])
            ->add('detalle', TextareaType::class, [
                'label' => 'tax.form.name',
                'attr' => ['rows'=>10,'cols'=>80],
                'translation_domain' => 'core',
            ])
            ->add('numFacMes', NumberType::class, [
                //'scale' => 2,
                'scale' => 0,
                'grouping' => true,
                'label' => 'Número de Facturas al Mes',
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)"]
            ])
            ->add('valMaxFac', NumberType::class, [
                //'scale' => 2,
                'scale' => 2,
                'grouping' => true,
                'label' => 'Valor Maximo por Factura',
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)"]
            ])
            ->add('precioMes', NumberType::class, [
                //'scale' => 2,
                'scale' => 2,
                'grouping' => true,
                'label' => 'Precio al Mes',
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)"]
            ])
            ->add('orden', NumberType::class, [
                //'scale' => 2,
                'scale' => 0,
                'grouping' => true,
                'label' => 'Orden Listado',
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)"]
            ])
            ->add('ilimitado', CheckboxType::class, [
                'required' => false,
                'label' => 'Ilimitado',
            ])
            ->add('diasPago', NumberType::class, [
                //'scale' => 2,
                'scale' => 0,
                'grouping' => true,
                'label' => 'Dias Pago',
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)"]
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\Planes',
        ]);
    }
}
