<?php

namespace App\Form;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProviderType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', null, [
                'label' => 'form.name',
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off'],
                'translation_domain' => 'provider',
            ])
            ->add('identification', null, [
                'required' => true,
                'label' => 'form.identification',
                'attr' => ['autocomplete' => 'off', 'onchange'=>'tipodocumento(this)'],
                'translation_domain' => 'provider',
            ])
            ->add('email', null, [
                'required' => true,
                'label' => 'form.email',
                'attr' => ['autocomplete' => 'off'],
                'translation_domain' => 'provider',
            ])
            /*->add('contact_person', null, [
                'label' => 'form.contact_person',
                'translation_domain' => 'provider',
            ])
            */
            ->add('address', null, [
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off'],
                'label' => 'form.invoicing_address',
                'translation_domain' => 'provider',
            ])
            /*
            ->add('shipping_address', TextareaType::class, [
                'required' => false,
                'label' => 'form.shipping_address',
                'translation_domain' => 'provider',
            ])
*/
            ->add('tipoDocumento', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'form.tipo_identificacion', 'attr' => ['class' => 'form-control', 'autocomplete' => 'off', 'onchange'=>'tipodocumento(this)'], 'label_attr' => ['class' => 'control-label'], 'choices' => ['form.ruc' => '04', 'form.cedula' => '05', 'form.pasaporte' => '06', 'form.exterior' => '08'], 'required'    => true, 'placeholder' => 'form.seleccione', 'empty_data'  => null, 'translation_domain' => 'provider'])

            ->add('telefono', null, [
                'label' => 'form.telefono',
                'translation_domain' => 'provider',
                'attr' =>['class'=>'intTextBox', 'autocomplete' => 'off']
            ])
            ->add('tipoProveedor', ChoiceType::class, [
                'label' => 'form.tipoprov',
                'choices' => [
                    'form.provnatural' => '01',
                    'form.provsociedad' => '02'
                ],
                'required' => true,
                'attr' => ['autocomplete' => 'off'],
                'translation_domain' => 'provider',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Provider::class,
            'attr' => ['id' => 'formprovidersv']
        ]);
    }
}
