<?php

namespace App\Form;

use App\Entity\Model\PlacasSocios;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SocioTransporteType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $estransportista = $options['estransportista'];

        $builder->add('rucsocio', TextType::class, [
                'required' => true,
                'attr' => array('maxlength' => 13, 'autocomplete' => 'off'),
                'label' => 'RUC',
            ])
            ->add('nombresocio', TextType::class, [
                'required' => true,
                'attr' => array('maxlength' => 100, 'autocomplete' => 'off'),
                'label' => 'Razón Social',
            ])
            ->add('ptoemisionsocio', TextType::class, [
                'required' => true,
                'label' => 'Punto Emisión',
                'attr' => array('maxlength' => 3, 'autocomplete' => 'off'),
            ])
            ->add('tpcontribuyentesocio', ChoiceType::class, [
                'label' => 'Tipo Contribuyente',
                'required' => true,
                'choices' => array(
                    'GENERAL' => 'GENERAL',
                    'RIMPE' => 'RIMPE',
                ),
            ])
            ->add('email', null, [
                'required' => true,
                'label' => 'form.email',
                'attr' => ['autocomplete' => 'off'],
                'translation_domain' => 'customer',
            ])
            ->add('password', TextType::class, [
                'required' => true,
                'attr' => array('maxlength' => 15, 'autocomplete' => 'off'),
                'label' => 'Contraseña',
            ])
            ->add('enabled', CheckboxType::class, [
                'required' => false,
                'label' => 'Habilitado',
            ]);

        $newPlaca = new PlacasSocios();
        $builder->add('placas', CollectionType::class, array(
            'entry_type' => 'App\Form\PlacaType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newPlaca,

        ));

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\TransporteSocio',
            'attr' => ['id' => 'transporte_settingssv'],
            'estransportista' => false,
        ]);
    }

}
