<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransportistaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

            $tipoDoc = ['form.ruc' => '04', 'form.cedula' => '05', 'form.pasaporte' => '06', 'form.exterior' => '08'];

        $builder
            ->add('name', null, [
                'label' => 'form.name',
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off'],
                'translation_domain' => 'invoice',
            ])
            ->add('identification', null, [
                'required' => true,
                'label' => 'form.identification',
                'attr' => ['autocomplete' => 'off'],
                'translation_domain' => 'customer',
            ])
            ->add('email', null, [
                'required' => true,
                'label' => 'form.email',
                'attr' => ['autocomplete' => 'off'],
                'translation_domain' => 'customer',
            ])
            /*->add('contact_person', null, [
                'label' => 'form.contact_person',
                'translation_domain' => 'customer',
            ])
            */
            ->add('address', TextType::class, [
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off'],
                'label' => 'Dirección',

                'translation_domain' => 'customer',
            ])
            ->add('placa', TextType::class, [
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off', 'maxlength' => 7],
                'label' => 'Placa',
            ])
            /*
            ->add('shipping_address', TextareaType::class, [
                'required' => false,
                'label' => 'form.shipping_address',
                'translation_domain' => 'customer',
            ])
*/
            ->add('tipoDocumento', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'form.tipo_identificacion', 'attr' => ['class' => 'form-control', 'autocomplete' => 'off', 'onchange'=>'tipodocumento(this)'], 'label_attr' => ['class' => 'control-label'], 'choices' => $tipoDoc, 'required'    => true, 'placeholder' => 'form.seleccione', 'empty_data'  => null, 'translation_domain' => 'customer'])

            ->add('telefono', null, [
                'label' => 'form.telefono',
                'translation_domain' => 'customer',
                'attr' =>['class'=>'intTextBox', 'autocomplete' => 'off'],

            ]);


    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Transportista::class,
            'attr' => ['id' => 'formtransportistasv'],
        ]);
    }
}
