<?php

namespace App\Electronico;

use App\Electronico\GuiaRemision\Destinatario;
use App\Electronico\GuiaRemision\Detalle;
use App\Electronico\GuiaRemision\InfoGuiaRemision;
use App\Electronico\LiquidacionCompra\ImpuestoDetalle;
use App\Electronico\LiquidacionCompra\InfoLiquidacionCompra;
use App\Electronico\LiquidacionCompra\LiquidacionCompra;
use App\Electronico\LiquidacionCompra\ReembolsoDetalle;
use App\Entity\Model\Empresa;
use App\Entity\Model\GuiaRemision;
use App\Entity\Model\ItemGuia;
use App\Entity\Model\ItemInvoiceReembolso;
use App\Entity\Model\Liquidacion;
use App\Entity\Model\Ncredito;
use App\Entity\Model\Reembolso;
use App\Entity\Model\Transportista;
use Exception;
use App\Electronico\Facturas\Detalle as DetalleFactura;
use \App\Electronico\NotaCreditos\Detalle as DetalleNCredito;
use \App\Electronico\LiquidacionCompra\Detalle as DetalleLiqCompra;
use App\Electronico\Facturas\Factura;
use App\Electronico\Facturas\InfoFactura;
use App\Electronico\NotaCreditos\InfoNotaCredito;
use App\Electronico\NotaCreditos\NotaCredito;
use App\Electronico\Retencion\ComprobanteRetencion;
use App\Electronico\Retencion\InfoCompRetencion;
use App\Entity\Model\Invoice;
use App\Entity\Model\Retencion;


class Comprobante
{
    public $nombreComercial;
    private $ruc;

    private $url;

    private $ptoemision;

    private $codestab;

    private $ambiente;

    private $razonSocial;

    private $claveAcceso;

    private $direccion;

    private $llevaconta;

    private $direccionMatriz;

    private $porcentajeIva= "12";
    /**
     * @return mixed
     */
    public function getClaveAcceso()
    {
        return $this->claveAcceso;
    }

    private $labelRimpe = 'CONTRIBUYENTE RÉGIMEN RIMPE';
    private $labelNegPopular = 'CONTRIBUYENTE NEGOCIO POPULAR - RÉGIMEN RIMPE';
    public function __construct($url, Empresa $empresa, $serie)
    {
        $this->url = $url;

        $iniruc = substr($empresa->getRuc(),0,10);
        $finruc = substr($empresa->getRuc(),10,3);

        if ($finruc != '001' || $finruc !== '001')
            $finruc = '001';

        $this->ruc = $iniruc.$finruc;

        $this->codestab = substr($serie, 0, 3);
        $this->ptoemision = substr($serie, 3, 3);
        $this->ambiente = $empresa->getTipoAmbiente();
        $this->llevaconta = $empresa->getLlevaContabilidad();

        $this->razonSocial = $empresa->getRazonSocial();
        $this->nombreComercial = $empresa->getNombreComercial();
        $this->direccion = $empresa->getDirEstablecimiento();
        $this->direccionMatriz = $empresa->getDireccionMatriz() === null ? $empresa->getDirEstablecimiento() : $empresa->getDireccionMatriz();
    }

    public function getInfoTributaria($codDoc, $secuencial, Empresa $empresa)
    {

        $infoTributaria = new InfoTributaria();
        $infoTributaria->setCodDoc($codDoc);
        $infoTributaria->setAmbiente($this->ambiente);
        $infoTributaria->setRazonSocial($this->razonSocial);

        if ($empresa->getNombreComercial() != null && strlen($empresa->getNombreComercial()) > 0)
            $infoTributaria->setNombreComercial($empresa->getNombreComercial());

        $infoTributaria->setRuc($this->ruc);
        $infoTributaria->setPtoEmi($this->ptoemision);
        $infoTributaria->setEstab($this->codestab);
        $infoTributaria->setSecuencial(str_pad($secuencial, 9, "0", STR_PAD_LEFT));
        $infoTributaria->setDirMatriz($this->direccionMatriz);
        $infoTributaria->setClaveAcceso($this->claveAcceso);

        if ($empresa->getAgenteRet() != null && strlen(trim($empresa->getAgenteRet())) > 0)
            $infoTributaria->setAgenteRetencion(trim($empresa->getAgenteRet()));

        if ($empresa->getRimpe())
            $infoTributaria->setContribuyenteRimpe($this->labelRimpe);
        elseif($empresa->getNegpopular())
            $infoTributaria->setContribuyenteRimpe($this->labelNegPopular);

        return $infoTributaria;
    }

    public function generarXml(Invoice $invoice, &$error)
    {
        $error = false;

        try {
            $customer = $invoice->getCustomer();
            $empresa = $invoice->getEmpresa();

            $factura = new Factura();

            $infoTributaria = $this->getInfoTributaria('01', $invoice->getNumber(), $empresa);

            $infoFactura = new InfoFactura();
            $infoFactura->setFechaEmision($invoice->getIssueDate()->format('d/m/Y'));
            $infoFactura->setDirEstablecimiento($this->direccion);
            $infoFactura->setObligadoContabilidad($this->llevaconta);

            $infoFactura->setTipoIdentificacionComprador($customer->getTipoDocumento());
            $infoFactura->setRazonSocialComprador($customer->getName());
            $infoFactura->setIdentificacionComprador($customer->getIdentification());
            $infoFactura->setDireccionComprador($customer->getInvoicingAddress());

            $infoFactura->setTotalSinImpuestos($invoice->getNetAmount());
            $infoFactura->setTotalDescuento($invoice->getDiscountAmount());

            $infoFactura->setImporteTotal($invoice->getGrossAmount());

            $auxpago = $invoice->getPagos();

            foreach ($auxpago as $item) {
                $pago = new  Pago();
                $fpago = $item->getFormapago();

                if ($fpago) {
                    $pago->setFormaPago($fpago->getCodigo());
                    $pago->setTotal($item->getValor());

                    if ($item->getTiempo() != 'Ninguno') {
                        $pago->setPlazo($item->getPlazo());
                        $pago->setUnidadTiempo($item->getTiempo());
                    }
                } else {
                    $pago->setTotal($invoice->getGrossAmount());
                }

                $infoFactura->addPagos($pago);
            }

            $detalles = [];
            $ivaVal5=0;

            foreach ($invoice->getItems() as $item) {
                //$item = new  Item();
                $detalle = new DetalleFactura();
                $detalle->setCodigoPrincipal($item->getId());
                $detalle->setDescripcion($item->getDescription());
                $detalle->setCantidad($item->getQuantity(), $empresa->getDecpunit());
                $detalle->setPrecioUnitario($item->getUnitaryCost(), $empresa->getDecpunit());
                $detalle->setDescuento($item->getValdescuento());
                $detalle->setPrecioTotalSinImpuesto($item->getNeto());

                $impuestos = [];

                if ($item->getValiva() > 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(2);
                    if($item->getTasaimpuesto() == 15 || $item->getTasaimpuesto() == 15.00 ) {
                        $impuesto->setCodigoPorcentaje(4);
                        $this->porcentajeIva = "15";
                    }
                    else if($item->getTasaimpuesto() == 5 || $item->getTasaimpuesto() == 5.00 ) {
                        $impuesto->setCodigoPorcentaje(5);
                        $this->porcentajeIva = "5";
                        $ivaVal5 .= $item->getValiva();
                    }
                    $impuesto->setTarifa($item->getTasaimpuesto());
                    $impuesto->setBaseImponible($item->getNeto());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                } elseif ($item->getValiva() == 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(0); // IVA 0
                    $impuesto->setTarifa(0);
                    $impuesto->setBaseImponible($item->getNeto());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                }

                $detalle->setImpuestos($impuestos);

                $detalles[] = $detalle;
            }

            $impuestos = [];

            if ($invoice->getBaseiva() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(4);
                $impuesto->setBaseImponible($invoice->getBaseiva());
                $impuesto->setValor($invoice->getTaxAmount());

                $impuestos[] = $impuesto;
            }

            if ($invoice->getBaseIva5() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje('5');
                $impuesto->setBaseImponible($invoice->getBaseIva5());
                //$impuesto->setValor($invoice->getTaxAmount());
                $impuesto->setValor($ivaVal5);

                $impuestos[] = $impuesto;
            }

            if ($invoice->getBasecero() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(0); // IVA 0
                $impuesto->setBaseImponible($invoice->getBasecero());
                $impuesto->setValor(0.00);

                $impuestos[] = $impuesto;
            }

            $infoFactura->setTotalConImpuestos($impuestos);


            if($invoice->getEsReembolso()) {

                $infoFactura->setCodDocReembolso("41");
                $infoFactura->setTotalBaseImponibleReembolso($invoice->getBaseReemboAmount());
                $infoFactura->setTotalComprobantesReembolso($invoice->getBaseReemboAmount() + $invoice->getTaxReemboAmount());
                $infoFactura->setTotalImpuestoReembolso($invoice->getTaxReemboAmount());

                $reembolsos = [];

                foreach ($invoice->getReembolsos() as $item) {
                    //$item = new ItemInvoiceReembolso();
                    $reembolso = new ReembolsoDetalle();
                    $proveedor = $item->getProvider();
                    $reembolso->setTipoIdentificacionProveedorReembolso($proveedor->getTipoDocumento());
                    $reembolso->setIdentificacionProveedorReembolso($proveedor->getIdentification());
                    $reembolso->setCodPaisPagoProveedorReembolso($item->getProviderCodpais());
                    $reembolso->setTipoProveedorReembolso($proveedor->getTipoProveedor());
                    $reembolso->setCodDocReembolso(str_pad($item->getTipoDocReembolso()->getCodigo(), 2, "0", STR_PAD_LEFT));
                    $reembolso->setEstabDocReembolso(substr($item->getSerieDocumento(), 0, 3));
                    $reembolso->setPtoEmiDocReembolso(substr($item->getSerieDocumento(), 3, 3));
                    $reembolso->setSecuencialDocReembolso(str_pad($item->getSecuencialDoc(), 9, "0", STR_PAD_LEFT));
                    $reembolso->setFechaEmisionDocReembolso($item->getEmisionDocumento()->format('d/m/Y'));
                    $reembolso->setNumeroautorizacionDocReemb($item->getAutoDocumento());

                    $impuestos = [];

                    if ($item->getValiva() > 0) {
                        $impuesto = new ImpuestoDetalle();
                        $impuesto->setCodigo(2);
                        $impuesto->setCodigoPorcentaje(2);
                        if($item->getPorIva() == 15 || $item->getPorIva() == 15.00 ) {
                            $impuesto->setCodigoPorcentaje(4);
                            $this->porcentajeIva = "15";
                        }
                        else if($item->getPorIva() == 5 || $item->getPorIva() == 5.00 ) {
                            $impuesto->setCodigoPorcentaje(5);
                            $this->porcentajeIva = "5";
                        }
                        $impuesto->setTarifa($item->getTasaimpuesto());
                        $impuesto->setBaseImponibleReembolso($item->getBaseAmount());
                        $impuesto->setImpuestoReembolso($item->getValiva());

                        $impuestos[] = $impuesto;
                    } elseif ($item->getValiva() == 0) {
                        $impuesto = new ImpuestoDetalle();
                        $impuesto->setCodigo(2);
                        $impuesto->setCodigoPorcentaje(0); // IVA 0
                        $impuesto->setTarifa(0);
                        $impuesto->setBaseImponibleReembolso($item->getBaseAmount());
                        $impuesto->setImpuestoReembolso($item->getValiva());

                        $impuestos[] = $impuesto;
                    }

                    $reembolso->setDetalleImpuestos($impuestos);

                    $reembolsos[] = $reembolso;
                }

                $factura->setReembolsos($reembolsos);
            }

            $factura->setDetalles($detalles);
            $factura->setInfoFactura($infoFactura);
            $factura->setInfoTributaria($infoTributaria);

            $adicional = [];


            $campoadic4 = new CampoAdicional("Email", $customer->getEmail());
            $campoadic5 = new CampoAdicional("Dirección", $customer->getInvoicingAddress());
            $campoadic6 = new CampoAdicional("Teléfono", $customer->getTelefono() == null ? '0' : $customer->getTelefono());

            $adicional[] = $campoadic4;
            $adicional[] = $campoadic5;
            $adicional[] = $campoadic6;

            if ($invoice->getNotes() != null && strlen($invoice->getNotes()) > 0) {
                $campoadic = new CampoAdicional("Notas", $invoice->getNotes());
                $adicional[] = $campoadic;
            }

            if($invoice->getTransportesocio()){

                $socio = $invoice->getTransportesocio();
                //$socio = new TransporteSocio();
                $campoadic = new CampoAdicional("PUNTO EMISIÓN", $socio->getPtoemisionsocio());
                $adicional[] = $campoadic;

                $campoadic = new CampoAdicional("RUC", $socio->getRucsocio());
                $adicional[] = $campoadic;

                $campoadic = new CampoAdicional("RAZÓN SOCIAL", $socio->getNombresocio());
                $adicional[] = $campoadic;

                $campoadic = new CampoAdicional("TP. CONTRIBUYENTE", $socio->getTpcontribuyentesocio());
                $adicional[] = $campoadic;

                $campoadic = new CampoAdicional("PLACA", $invoice->getPlaca());
                $adicional[] = $campoadic;

            }

            $factura->setInfoAdicional($adicional);

            return $factura;


        } catch (Exception $exception) {
            $error = true;
            return $exception->getMessage();

        }

        return null;
    }

    public function generarXmlGuiaRemision(GuiaRemision $guia, &$error)
    {
        $error = false;

        try {
            $empresa = $guia->getEmpresa();

            $infoTributaria = $this->getInfoTributaria('06', $guia->getNumber(), $empresa);

            $infoGuiaRemision = new InfoGuiaRemision();
            $infoGuiaRemision->setDirEstablecimiento($this->direccion);
            $infoGuiaRemision->setObligadoContabilidad($this->llevaconta);
            $infoGuiaRemision->setDirPartida($guia->getDireccionpPartida());

            $transportista = $guia->getTransportista();
            //$transportista = new Transportista();

            $infoGuiaRemision->setTipoIdentificacionTransportista($transportista->getTipoDocumento());
            $infoGuiaRemision->setRazonSocialTransportista($transportista->getName());
            $infoGuiaRemision->setRucTransportista($transportista->getIdentification());
            $infoGuiaRemision->setPlaca($transportista->getPlaca());

            $infoGuiaRemision->setFechaIniTransporte($guia->getFeciniTransporte()->format('d/m/Y'));
            $infoGuiaRemision->setFechaFinTransporte($guia->getFecfinTransporte()->format('d/m/Y'));

            $destinatarios = [];

            foreach ($guia->getDestinatarios() as $item) {
                //$item = new \App\Entity\Model\Destinatario();
                //$customer = $item->get
                $destinatario = new Destinatario();
                $destinatario->setIdentificacionDestinatario($item->getCustomerIdentification());
                $destinatario->setRazonSocialDestinatario($item->getCustomerName());
                $destinatario->setDirDestinatario($item->getDirDestino());
                $destinatario->setMotivoTraslado($item->getMotivoTraslado());

                if ($item->getDocAduanero())
                    $destinatario->setDocAduaneroUnico($item->getDocAduanero());

                if ($item->getCodEstabDestino())
                    $destinatario->setCodEstabDestino($item->getCodEstabDestino());

                if ($item->getRuta())
                    $destinatario->setRuta($item->getRuta());

                if ($item->getRuta())
                    $destinatario->setRuta($item->getRuta());

                if ($item->getInvoiceNumero())
                    $destinatario->setCodDocSustento('01');

                if ($item->getInvoiceNumero())
                    $destinatario->setNumDocSustento(substr($item->getInvoiceSerie(), 0, 3) . "-" . substr($item->getInvoiceSerie(), 3, 3) . "-" . str_pad($item->getInvoiceNumero(), 9, "0", STR_PAD_LEFT));

                if ($item->getInvoiceAutorizacion())
                    $destinatario->setNumAutDocSustento($item->getInvoiceAutorizacion());

                if ($item->getInvoiceNumero())
                    $destinatario->setFechaEmisionDocSustento($item->getinvoiceFecha()->format('d/m/Y'));

                $detalles = [];

                foreach ($item->getItems() as $itemguia) {

                    //$itemguia = new ItemGuia();

                    $detalle = new Detalle();
                    $detalle->setCodigoInterno($itemguia->getId());
                    $detalle->setDescripcion($itemguia->getDescription());
                    $detalle->setCantidad($itemguia->getQuantity());

                    $detalles[] = $detalle;
                }

                $destinatario->setDetalles($detalles);

                $destinatarios[] = $destinatario;
            }

            $guiaRemision = new \App\Electronico\GuiaRemision\GuiaRemision();

            $guiaRemision->setDestinatarios($destinatarios);
            $guiaRemision->setInfoGuiaRemision($infoGuiaRemision);
            $guiaRemision->setInfoTributaria($infoTributaria);

            $adicional = [];

            if ($guia->getNotes() != null && strlen($guia->getNotes()) > 0) {
                $campoadic = new CampoAdicional("Notas", $guia->getNotes());
                $adicional[] = $campoadic;
            }

            $guiaRemision->setInfoAdicional($adicional);

            return $guiaRemision;


        } catch (Exception $exception) {
            $error = true;
            return $exception->getMessage();

        }

        return null;
    }

    public function generarXmlCredito(Ncredito $credito, &$error)
    {
        $error = false;

        try {
            $customer = $credito->getCustomer();
            $empresa = $credito->getEmpresa();

            $notaCredito = new NotaCredito();

            $infoTributaria = $this->getInfoTributaria('04', $credito->getNumber(), $empresa);

            $infoNotaCredito = new InfoNotaCredito();
            $infoNotaCredito->setFechaEmision($credito->getIssueDate()->format('d/m/Y'));
            $infoNotaCredito->setDirEstablecimiento($this->direccion);
            $infoNotaCredito->setObligadoContabilidad($this->llevaconta);

            $infoNotaCredito->setTipoIdentificacionComprador($customer->getTipoDocumento());
            $infoNotaCredito->setRazonSocialComprador($customer->getName());
            $infoNotaCredito->setIdentificacionComprador($customer->getIdentification());

            $infoNotaCredito->setTotalSinImpuestos($credito->getNetAmount());


            $infoNotaCredito->setCodDocModificado("01");
            $infoNotaCredito->setNumDocModificado(substr($credito->getSerieDocSustento(), 0, 3) . "-" . substr($credito->getSerieDocSustento(), 3, 3) . "-" . str_pad($credito->getNumeroDocSustento(), 9, "0", STR_PAD_LEFT));
            $infoNotaCredito->setFechaEmisionDocSustento($credito->getFecDocSustento()->format('d/m/Y'));
            $infoNotaCredito->setValorModificacion($credito->getGrossAmount());
            $infoNotaCredito->setMotivo($credito->getMotivo());

            $detalles = [];

            foreach ($credito->getItems() as $item) {
                $detalle = new DetalleNCredito();
                $detalle->setCodigoInterno($item->getId());
                $detalle->setDescripcion($item->getDescription());
                $detalle->setCantidad($item->getQuantity());
                $detalle->setPrecioUnitario($item->getUnitaryCost());
                $detalle->setDescuento($item->getDiscountAmount());
                $detalle->setPrecioTotalSinImpuesto($item->getNetAmount());

                $impuestos = [];

                if ($item->getValiva() > 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(2);
                    if($item->getTasaimpuesto() == 15 || $item->getTasaimpuesto() == 15.00 ) {
                        $impuesto->setCodigoPorcentaje(4);
                        $this->porcentajeIva = "15";
                    }
                    else if($item->getTasaimpuesto() == 5 || $item->getTasaimpuesto() == 5.00 ) {
                        $impuesto->setCodigoPorcentaje(5);
                        $this->porcentajeIva = "5";
                    }
                    $impuesto->setTarifa($item->getTasaimpuesto());
                    $impuesto->setBaseImponible($item->getSubtotal());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                } elseif ($item->getValiva() == 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(0); // IVA 0
                    $impuesto->setTarifa(0);
                    $impuesto->setBaseImponible($item->getSubtotal());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                }

                $detalle->setImpuestos($impuestos);

                $detalles[] = $detalle;
            }

            $impuestos = [];

            if ($credito->getBaseiva() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(2);
                if ($this->porcentajeIva == '15')
                    $impuesto->setCodigoPorcentaje(4);
                elseif ($this->porcentajeIva == '5')
                    $impuesto->setCodigoPorcentaje(5);
                $impuesto->setBaseImponible($credito->getBaseiva());
                $impuesto->setValor($credito->getTaxAmount());

                $impuestos[] = $impuesto;
            }

            if ($credito->getBasecero() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(0); // IVA 0
                $impuesto->setBaseImponible($credito->getBasecero());
                $impuesto->setValor(0.00);

                $impuestos[] = $impuesto;
            }

            $infoNotaCredito->setTotalConImpuestos($impuestos);

            $notaCredito->setDetalles($detalles);
            $notaCredito->setInfoNotaCredito($infoNotaCredito);
            $notaCredito->setInfoTributaria($infoTributaria);

            $adicional = [];

            /*if($empresa->getMicroempresa()) {
                $campoadic = new CampoAdicional("CONTRIBUYENTE", "REGIMEN RIMPE");
                $adicional[] = $campoadic;
            }*/

            $campoadic1 = new CampoAdicional("Email", $customer->getEmail());
            $campoadic2 = new CampoAdicional("Dirección", $customer->getInvoicingAddress());
            $campoadic3 = new CampoAdicional("Teléfono", $customer->getTelefono() == null ? '0' : $customer->getTelefono());

            $adicional[] = $campoadic1;
            $adicional[] = $campoadic2;
            $adicional[] = $campoadic3;

            if ($credito->getNotes() !== null && strlen($credito->getNotes()) > 0) {
                $campoadic = new CampoAdicional("Notas", $credito->getNotes());
                $adicional[] = $campoadic;
            }

            $notaCredito->setInfoAdicional($adicional);

            return $notaCredito;
        } catch (Exception $exception) {
            $error = true;
            return $exception->getMessage();

        }

        return null;
    }

    public function generarXmlRetencion(Retencion $retencion, &$error)
    {
        $error = false;

        try {
            $provider = $retencion->getProvider();
            $empresa = $retencion->getEmpresa();

            $compRetencion = new ComprobanteRetencion();

            $infoTributaria = $this->getInfoTributaria('07', $retencion->getNumber(), $empresa);

            $infoCompRetencion = new InfoCompRetencion();
            $infoCompRetencion->setFechaEmision($retencion->getIssueDate()->format('d/m/Y'));
            $infoCompRetencion->setDirEstablecimiento($this->direccion);
            $infoCompRetencion->setObligadoContabilidad($this->llevaconta);

            $infoCompRetencion->setTipoIdentificacionSujetoRetenido($provider->getTipoDocumento());
            $infoCompRetencion->setRazonSocialSujetoRetenido($provider->getName());
            $infoCompRetencion->setIdentificacionSujetoRetenido($provider->getIdentification());
            $infoCompRetencion->setPeriodoFiscal($retencion->getMes() . "/" . $retencion->getAnio());

            $impuestos = [];

            $totalRetenido = 0;
            foreach ($retencion->getItems() as $item) {
                //$item = new ItemRetencion();
                $impuesto = new \App\Electronico\Retencion\Impuesto();

                $codigo = $item->getTipoRetencion()->getTipo() === "I" ? 2 : 1;

                $impuesto->setCodigo($codigo);

                $impuesto->setCodigoRetencion($item->getTipoRetencion()->getCodigo());

                if ($item->getTipoRetencion()->getTipo() === "I")
                    $impuesto->setCodigoRetencion($this->mapearTablaCodRetencion($item->getPorcentaje()));

                $impuesto->setBaseImponible($item->getBase());
                $impuesto->setPorcentajeRetener($item->getPorcentaje());
                $impuesto->setValorRetenido($item->getRetenido());
                $impuesto->setCodDocSustento($retencion->getCodigoDocSustento());
                $impuesto->setNumDocSustento($retencion->getSerieCompra() . str_pad($retencion->getNumeroCompra(), 9, "0", STR_PAD_LEFT));
                $impuesto->setFechaEmisionDocSustento($retencion->getFechaCompra()->format('d/m/Y'));

                $impuestos[] = $impuesto;
                $totalRetenido += $item->getRetenido();
            }

            $compRetencion->setImpuestos($impuestos);
            $compRetencion->setInfoCompRetencion($infoCompRetencion);
            $compRetencion->setInfoTributaria($infoTributaria);

            $adicional = [];

            /*if($empresa->getMicroempresa()) {
                $campoadic = new CampoAdicional("CONTRIBUYENTE", "REGIMEN RIMPE");
                $adicional[] = $campoadic;
            }*/

            $campoadic1 = new CampoAdicional("Email", $provider->getEmail());
            $campoadic3 = new CampoAdicional("Telefono", $provider->getTelefono() == null ? '0' : $provider->getTelefono());

            $adicional[] = $campoadic1;
            $adicional[] = $campoadic3;

            $campoadic4 = new CampoAdicional("Tot. Retenido", number_format($totalRetenido, 2, '.', ''));
            $adicional[] = $campoadic4;

            if ($retencion->getNotes() !== null && strlen($retencion->getNotes()) > 0) {
                $campoadic = new CampoAdicional("Notas", $retencion->getNotes());
                $adicional[] = $campoadic;
            }

            $compRetencion->setInfoAdicional($adicional);

            return $compRetencion;


        } catch (Exception $exception) {
            $error = true;
            return $exception->getMessage();

        }

        return null;
    }

    public function generarXmlLiquidacion(Liquidacion $liquidacion, &$error)
    {
        $error = false;

        try {
            $provider = $liquidacion->getProvider();
            $empresa = $liquidacion->getEmpresa();

            $liquidacionCompra = new LiquidacionCompra();

            $infoTributaria = $this->getInfoTributaria('03', $liquidacion->getNumber(), $empresa);

            $infoLiquiCompra = new InfoLiquidacionCompra();
            $infoLiquiCompra->setFechaEmision($liquidacion->getIssueDate()->format('d/m/Y'));
            $infoLiquiCompra->setDirEstablecimiento($this->direccion);
            $infoLiquiCompra->setObligadoContabilidad($this->llevaconta);

            $infoLiquiCompra->setTipoIdentificacionProveedor($provider->getTipoDocumento());
            $infoLiquiCompra->setRazonSocialProveedor($provider->getName());
            $infoLiquiCompra->setIdentificacionProveedor($provider->getIdentification());
            $infoLiquiCompra->setDireccionProveedor($provider->getAddress());

            $infoLiquiCompra->setTotalSinImpuestos($liquidacion->getNetAmount());
            $infoLiquiCompra->setTotalDescuento(0.00);

            if ($liquidacion->getEsReembolso()) {
                $infoLiquiCompra->setCodDocReembolso("41");
                $infoLiquiCompra->setTotalBaseImponibleReembolso($liquidacion->getBaseReemboAmount());
                $infoLiquiCompra->setTotalComprobantesReembolso($liquidacion->getBaseReemboAmount() + $liquidacion->getTaxReemboAmount());
                $infoLiquiCompra->setTotalImpuestoReembolso($liquidacion->getTaxReemboAmount());

            }

            $infoLiquiCompra->setImporteTotal($liquidacion->getGrossAmount());

            $auxpago = $liquidacion->getPagos();

            foreach ($auxpago as $item) {
                $pago = new  Pago();
                $fpago = $item->getFormapago();

                if ($fpago) {
                    $pago->setFormaPago($fpago->getCodigo());
                    $pago->setTotal($item->getValor());

                    if ($item->getTiempo() != 'Ninguno') {
                        $pago->setPlazo($item->getPlazo());
                        $pago->setUnidadTiempo($item->getTiempo());
                    }
                } else {
                    $pago->setTotal($liquidacion->getGrossAmount());
                }

                $infoLiquiCompra->addPagos($pago);
            }

            $detalles = [];

            foreach ($liquidacion->getItems() as $item) {
                $detalle = new DetalleLiqCompra();
                $detalle->setCodigoPrincipal($item->getId());
                $detalle->setDescripcion($item->getDescription());
                $detalle->setCantidad($item->getQuantity());
                $detalle->setPrecioUnitario($item->getUnitaryCost());
                $detalle->setDescuento($item->getDiscountAmount());
                $detalle->setPrecioTotalSinImpuesto($item->getNetAmount());

                $impuestos = [];

                if ($item->getValiva() > 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(2);
                    if($item->getTasaimpuesto() == 15 || $item->getTasaimpuesto() == 15.00 ) {
                        $impuesto->setCodigoPorcentaje(4);
                        $this->porcentajeIva = "15";
                    }
                    else if($item->getTasaimpuesto() == 5 || $item->getTasaimpuesto() == 5.00 ) {
                        $impuesto->setCodigoPorcentaje(5);
                        $this->porcentajeIva = "5";
                    }
                    $impuesto->setTarifa($item->getTasaimpuesto());

                    $impuesto->setBaseImponible($item->getSubtotal());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                } elseif ($item->getValiva() == 0) {
                    $impuesto = new Impuesto();
                    $impuesto->setCodigo(2);
                    $impuesto->setCodigoPorcentaje(0); // IVA 0
                    $impuesto->setTarifa(0);
                    $impuesto->setBaseImponible($item->getSubtotal());
                    $impuesto->setValor($item->getValiva());

                    $impuestos[] = $impuesto;
                }

                $detalle->setImpuestos($impuestos);

                $detalles[] = $detalle;
            }

            $impuestos = [];

            if ($liquidacion->getBaseiva() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(2);
                if ($this->porcentajeIva == '15')
                    $impuesto->setCodigoPorcentaje(4);
                elseif ($this->porcentajeIva == '5')
                    $impuesto->setCodigoPorcentaje(5);
                $impuesto->setBaseImponible($liquidacion->getBaseiva());
                $impuesto->setValor($liquidacion->getTaxAmount());

                $impuestos[] = $impuesto;
            }

            if ($liquidacion->getBasecero() > 0) {
                $impuesto = new Impuesto();
                $impuesto->setCodigo(2);
                $impuesto->setCodigoPorcentaje(0); // IVA 0
                $impuesto->setBaseImponible($liquidacion->getBasecero());
                $impuesto->setValor(0.00);

                $impuestos[] = $impuesto;
            }

            $infoLiquiCompra->setTotalConImpuestos($impuestos);

            if ($liquidacion->getEsReembolso()) {
                $reembolsos = [];

                foreach ($liquidacion->getReembolsos() as $item) {
                    //$item = new Reembolso();
                    $reembolso = new ReembolsoDetalle();
                    $proveedor = $item->getProvider();
                    $reembolso->setTipoIdentificacionProveedorReembolso($proveedor->getTipoDocumento());
                    $reembolso->setIdentificacionProveedorReembolso($proveedor->getIdentification());
                    $reembolso->setCodPaisPagoProveedorReembolso($item->getProviderCodpais());
                    $reembolso->setTipoProveedorReembolso($proveedor->getTipoProveedor());
                    $reembolso->setCodDocReembolso(str_pad($item->getTipoDocReembolso()->getCodigo(), 2, "0", STR_PAD_LEFT));
                    $reembolso->setEstabDocReembolso(substr($item->getSerieDocumento(), 0, 3));
                    $reembolso->setPtoEmiDocReembolso(substr($item->getSerieDocumento(), 3, 3));
                    $reembolso->setSecuencialDocReembolso(str_pad($item->getSecuencialDoc(), 9, "0", STR_PAD_LEFT));
                    $reembolso->setFechaEmisionDocReembolso($item->getEmisionDocumento()->format('d/m/Y'));
                    $reembolso->setNumeroautorizacionDocReemb($item->getAutoDocumento());

                    $impuestos = [];

                    if ($item->getValiva() > 0) {
                        $impuesto = new ImpuestoDetalle();
                        $impuesto->setCodigo(2);
                        $impuesto->setCodigoPorcentaje(2);
                        if($item->getPorIva() == 15 || $item->getPorIva() == 15.00 ) {
                            $impuesto->setCodigoPorcentaje(4);
                            $this->porcentajeIva = "15";
                        }
                        else if($item->getPorIva() == 5 || $item->getPorIva() == 5.00 ) {
                            $impuesto->setCodigoPorcentaje(5);
                            $this->porcentajeIva = "5";
                        }
                        $impuesto->setTarifa($item->getTasaimpuesto());
                        $impuesto->setBaseImponibleReembolso($item->getBaseAmount());
                        $impuesto->setImpuestoReembolso($item->getValiva());

                        $impuestos[] = $impuesto;
                    } elseif ($item->getValiva() == 0) {
                        $impuesto = new ImpuestoDetalle();
                        $impuesto->setCodigo(2);
                        $impuesto->setCodigoPorcentaje(0); // IVA 0
                        $impuesto->setTarifa(0);
                        $impuesto->setBaseImponibleReembolso($item->getBaseAmount());
                        $impuesto->setImpuestoReembolso($item->getValiva());

                        $impuestos[] = $impuesto;
                    }

                    $reembolso->setDetalleImpuestos($impuestos);

                    $reembolsos[] = $reembolso;
                }

                $liquidacionCompra->setReembolsos($reembolsos);
            }

            $liquidacionCompra->setDetalles($detalles);
            $liquidacionCompra->setInfoLiquidacionCompra($infoLiquiCompra);
            $liquidacionCompra->setInfoTributaria($infoTributaria);

            $adicional = [];

            $campoadic4 = new CampoAdicional("Email", $provider->getEmail());
            $campoadic5 = new CampoAdicional("Dirección", $provider->getAddress());
            $campoadic6 = new CampoAdicional("Teléfono", $provider->getTelefono() == null ? '0' : $provider->getTelefono());

            $adicional[] = $campoadic4;
            $adicional[] = $campoadic5;
            $adicional[] = $campoadic6;

            if ($liquidacion->getNotes() != null && strlen($liquidacion->getNotes()) > 0) {
                $campoadic = new CampoAdicional("Notas", $liquidacion->getNotes());
                $adicional[] = $campoadic;
            }

            $liquidacionCompra->setInfoAdicional($adicional);

            return $liquidacionCompra;


        } catch (Exception $exception) {
            $error = true;
            return $exception->getMessage();

        }

        return null;
    }

    public function generaClave($fechaEmision, $tipoComprobante, $numeroComprobante)
    {
        $tipoEmision = "1";
        $codigoNumerico = "15012008";

        if (($this->ruc != null) && (strlen($this->ruc) < 13)) {
            return 'numero de ruc es null o menor de 13 dígitos';
        }

        $fecha = str_replace('/', '', $fechaEmision);
        $serie = $this->codestab . $this->ptoemision;

        $clave = $fecha . $tipoComprobante . $this->ruc . $this->ambiente . $serie . $numeroComprobante . $codigoNumerico . $tipoEmision;

        $verificador = $this->generaDigitoModulo11((string)$clave);

        $clave .= (int) $verificador;

        $this->claveAcceso = (string)$clave;

        if (strlen($clave) != 49) {
            $this->claveAcceso = null;
            return "longitud de la clave de accesso debe ser de 49 dígitos";

        }

        return null;
    }

    private function generaDigitoModulo11($cadena)
    {
        $aux = [];
        $baseMultiplicador = 7;

        $multiplicador = 2;
        $total = 0;
        $verificador = 0;

        for ($i = strlen($cadena) - 1; $i >= 0; --$i) {
            $aux[$i] = substr($cadena, $i, 1);
            $aux[$i] *= $multiplicador;
            ++$multiplicador;
            if ($multiplicador > $baseMultiplicador) {
                $multiplicador = 2;
            }

            $total += $aux[$i];
        }

        if (($total === 0) || ($total == 1)) {
            $verificador = 0;
        } else {
            $verificador = 11 - $total % 11 == 11 ? 0 : 11 - $total % 11;
        }

        if ($verificador == 10) {
            $verificador = 1;
        }

        return $verificador;
    }

    private function mapearTablaCodRetencion($porcentaje)
    {
        $codigoRetencion = "";
        switch ($porcentaje) {
            case "30":
                $codigoRetencion = "1";
                break;
            case "70":
                $codigoRetencion = "2";
                break;
            case "100":
                $codigoRetencion = "3";
                break;
            case "0":
                $codigoRetencion = "7";
                break;
            case "10":
                $codigoRetencion = "9";
                break;
            case "20":
                $codigoRetencion = "10";
                break;
        }

        return $codigoRetencion;
    }

    private function mapearTarifaIva($porcentaje)
    {
        $codigoTarifa = "";
        $porcentaje = (int) $porcentaje;
        switch ($porcentaje) {
            case 0:
                $codigoTarifa = "0";
                break;
            case 12:
                $codigoTarifa = "2";
                break;
            case 14:
                $codigoTarifa = "3";
                break;
        }

        return $codigoTarifa;
    }
}
