<?php

namespace App\Electronico\GuiaRemision;

use App\Electronico\InfoTributaria;
use JMS\Serializer\Annotation\Inline;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\XmlAttribute;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation\XmlRoot;

/** @XmlRoot("guiaRemision")
 */
class GuiaRemision
{

    /** @XmlAttribute
     *  @Type("string")
     */
    private $id ='comprobante';

    /** @XmlAttribute
     *  @Type("string")
     */
    private  $version = '1.0.0';

    /**
     * @SerializedName("infoTributaria")
     */
    private $infoTributaria;

    /**
     * @SerializedName("infoGuiaRemision")
     */
    private $infoGuiaRemision;

    /**
     * @XmlList(inline = false, entry = "destinatario")
     */
    private $destinatarios;


    /**
     * @SerializedName("infoAdicional")
     * @XmlList(inline = false, entry = "campoAdicional")
     */
    private  $infoAdicional;


    public function __construct()
    {
        $this->infoGuiaRemision = new InfoGuiaRemision();
        $this->infoTributaria = new InfoTributaria();
    }

    /**
     * @return mixed
     */
    public function getInfoTributaria()
    {
        return $this->infoTributaria;
    }

    /**
     * @param mixed $infoTributaria
     */
    public function setInfoTributaria(InfoTributaria $infoTributaria)
    {
        $this->infoTributaria = $infoTributaria;
    }


    /**
     * @return InfoGuiaRemision
     */
    public function getInfoGuiaRemision()
    {
        return $this->infoGuiaRemision;
    }

    /**
     * @param InfoGuiaRemision $infoGuiaRemision
     */
    public function setInfoGuiaRemision(InfoGuiaRemision $infoGuiaRemision)
    {
        $this->infoGuiaRemision = $infoGuiaRemision;
    }

    /**
     * @return mixed
     */
    public function getInfoAdicional()
    {
        return $this->infoAdicional;
    }

    /**
     * @param mixed $infoAdicional
     */
    public function setInfoAdicional(array  $infoAdicional)
    {
        $this->infoAdicional = $infoAdicional;
    }


    /**
     * @return mixed
     */
    public function getDestinatarios()
    {
        return $this->destinatarios;
    }

    /**
     * @param mixed $destinatarios
     */
    public function setDestinatarios($destinatarios)
    {
        $this->destinatarios = $destinatarios;
    }



}
