<?php

namespace App\Electronico\NotaCreditos;

use App\Electronico\InfoTributaria;
use JMS\Serializer\Annotation\Inline;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\XmlAttribute;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation\XmlRoot;

/** @XmlRoot("notaCredito")
 */
class NotaCredito
{

    /** @XmlAttribute
     * @Type("string")
     */
    private $id = 'comprobante';

    /** @XmlAttribute
     * @Type("string")
     */
    private $version = '1.0.0';

    /**
     * @SerializedName("infoTributaria")
     */
    private $infoTributaria;

    /**
     * @SerializedName("infoNotaCredito")
     */
    private $infoNotaCredito;

    /**
     * @XmlList(inline = false, entry = "detalle")
     */
    private $detalles;


    /**
     * @SerializedName("infoAdicional")
     * @XmlList(inline = false, entry = "campoAdicional")
     */
    private $infoAdicional;


    public function __construct()
    {
        $this->infoNotaCredito = new InfoNotaCredito();
        $this->infoTributaria = new InfoTributaria();
    }

    /**
     * @return mixed
     */
    public function getInfoTributaria()
    {
        return $this->infoTributaria;
    }

    /**
     * @param mixed $infoTributaria
     */
    public function setInfoTributaria(InfoTributaria $infoTributaria)
    {
        $this->infoTributaria = $infoTributaria;
    }

    /**
     * @return mixed
     */
    public function getInfoNotaCredito()
    {
        return $this->infoNotaCredito;
    }

    /**
     * @param mixed $infoNotaCredito
     */
    public function setInfoNotaCredito($infoNotaCredito)
    {
        $this->infoNotaCredito = $infoNotaCredito;
    }


    /**
     * @return mixed
     */
    public function getInfoAdicional()
    {
        return $this->infoAdicional;
    }

    /**
     * @param mixed $infoAdicional
     */
    public function setInfoAdicional(array $infoAdicional)
    {
        $this->infoAdicional = $infoAdicional;
    }

    /**
     * @return mixed
     */
    public function getDetalles()
    {
        return $this->detalles;
    }

    /**
     * @param mixed $detalles
     */
    public function setDetalles(array $detalles)
    {
        $this->detalles = $detalles;
    }


}
