<?php

namespace App\Form\Admin;

use App\Service\EmFactory;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class PropertyType extends AbstractType
{
    private $manager;
    private $security;
    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        /*$user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository('App\Entity\Model\Empresa');
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());
        */

        $builder
            /*->add('key', null, [
                'label' => 'form.reference',
                //'readonly'=>true,
                'attr' => ['class'=>'sv_uppercase'],

            ])*/
            ->add('name', TextType::class, [
                'label' => 'Nombre',
                'attr' => ['class'=>'sv_uppercase', 'readonly'=>'readonly'],

            ])
            ->add('value', TextType::class, [
                'label' => 'Valor',
                //'attr' => ['class'=>'sv_uppercase'],

            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\Property',
        ]);
    }
}
