<?php

namespace App\Form;

use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use App\Entity\Model\FormaPago;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemPagoType extends AbstractType
{

    private $manager;

    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('valor', NumberType::class, [
                'scale' => 2,
                'grouping' => true,
                'attr' => ['class' => 'svtext-right currencyTextBox', 'autocomplete' => 'off']
            ])
            ->add('plazo', NumberType::class, [
                'required' => true,
                'label' => 'Plazo',
                'attr' => ['class' => 'svtext-right intTextBox', 'autocomplete' => 'off']
            ]);


        $builder->add('tiempo', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'Tiempo', 'attr' => ['class' => 'form-control', 'autocomplete' => 'off'], 'label_attr' => ['class' => 'control-label'], 'choices' => ['form.ninguno' => 'Ninguno', 'form.dias' => 'Dias', 'form.meses' => 'Meses', 'form.anios' => 'Anios'], 'required' => true, 'multiple' => false, 'empty_data' => 'Ninguno', 'translation_domain' => 'invoice']);

        $builder->add('formapago', EntityType::class, [
            'class' => \App\Entity\Model\FormaPago::class,
            'choice_label' => static function (FormaPago $item, $key, $index) {
                return $item->getName();
            }, 'choice_value' => static function (FormaPago $entity = null) {
                return $entity !== null ? $entity->getId() : '';
            }, 'query_builder' => static function (EntityRepository $er) {
                return $er->createQueryBuilder('t')
                    ->where('t.enabled = 1');
            }, 'multiple' => false, 'required' => true, 'attr' => ['autocomplete' => 'off']]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\ItemPago::class,
        ]);
    }
}
