<?php

namespace App\Form;

use App\Entity\Model\Tax;
use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemType extends AbstractType
{
    private $manager;

    private $security;

    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        //$currency = $this->manager->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR');
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            //->add('product', TextType::class, ['required' => false])
            ->add('quantity', NumberType::class, [
                'attr' => ['class' => 'svtext-right', 'autocomplete' => 'off', 'onkeypress' => "return filterFloat(event,this)"]
            ])
            ->add('discount_percent', NumberType::class, [
                'scale' => 2,
                'attr' => ['class' => 'svtext-right', 'autocomplete' => 'off', 'onkeypress' => "return filterFloat(event,this)"]])
            ->add('description', TextType::class, [
                'attr' => [
                    'class' => 'svtext-right', 'autocomplete' => 'on',
                ]])
            ->add('unitary_cost', NumberType::class, [
                //'scale' => 2,
                'scale' => $this->empresa->getDecPunit(),
                'grouping' => true,
                'attr' => ['class' => 'svtext-right', 'autocomplete' => 'off', 'onkeypress' => "return filterFloat(event,this)"]
            ]);


        $builder->add('taxes', EntityType::class, [
            'class' => \App\Entity\Model\Tax::class,
            'choice_label' => static function (Tax $value, $key, $index) {
                return $value->getName();
            },
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('t')
                    ->where('t.active = 1')
                    ->andWhere('t.empresa = :empresa_id')
                    ->setParameter('empresa_id', $this->empresa->getId());
            },
            'multiple' => false,
            'required' => false,
            'attr' => ['autocomplete' => 'off']
        ]);


        /*
                $builder->add('taxes', 'Symfony\Component\Form\Extension\Core\Type\ChoiceType', array(
                    'label' => 'Iva',
                    'attr' => array('class' => 'form-control'),
                    'label_attr' => array('class' => 'control-label'),
                    'choices' => array(
                        'S' => 'S',
                        'N' => 'N'
                    ),
                    'required' => true,
                    'multiple' => false,
                    'empty_data' => 'S'
                ));
                */

        /*$builder->get('product')
            ->addModelTransformer(new CallbackTransformer(
                function ($product) {
                    return $product ? $product->getReference() : '';
                },
                function ($reference) {
                    $product = $this->manager
                        ->getRepository('SiwappProductBundle:Product')
                        ->findOneBy(['reference' => $reference]);

                    return $product;
                }
            ));
        */
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Item::class
        ]);
    }
}
