<?php

namespace App\Form;

use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RetencionType extends AbstractRetencionType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('issue_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.issue_date',
                'translation_domain' => 'retencion',
                'attr' => ['autocomplete' => 'off'],
            ])
            /*->add('forcefully_closed', null, [
                'label' => 'form.forcefully_closed',
                'translation_domain' => 'retencion',
            ])
            ->add('sent_by_email', null, [
                'label' => 'form.sent_by_email',
                'translation_domain' => 'retencion',
            ])*/


            ->add('fechaCompra', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.facfecha',
                'translation_domain' => 'retencion',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('anio', null, [
                'required'=> true,
                'label' => 'form.anio',
                'attr' => ['readonly' => false, 'maxlength' => 4, 'class'=>'intTextBox', 'autocomplete' => 'off'],
                'translation_domain' => 'retencion',
            ])
            ->add('serieCompra', null, [
                'label' => 'form.facserie',
                'attr' => ['readonly' => false, 'maxlength' => 6, 'minlength' => 6, 'class'=>'intTextBox', 'autocomplete' => 'off'],
                'translation_domain' => 'retencion',
            ])
            ->add('numeroCompra', null, [
                'required'=> true,
                'label' => 'form.facnumero',
                'attr' => ['readonly' => false, 'maxlength' => 9, 'class'=>'intTextBox', 'autocomplete' => 'off'],
                'translation_domain' => 'retencion',
            ])

            ->add('codigoDocSustento', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'form.labdocsustento', 'required'=> true, 'attr' => ['class' => 'form-control', 'autocomplete' => 'off'], 'label_attr' => ['class' => 'control-label'], 'choices' => ['form.susfactura' => '01', 'form.susliqui' => '03'], 'placeholder' => 'form.seleccione', 'empty_data' => null, 'translation_domain' => 'retencion'])

            ->add('mes', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class, ['label' => 'form.mes', 'required'=> true, 'attr' => ['class' => 'form-control', 'autocomplete' => 'off'], 'label_attr' => ['class' => 'control-label'], 'choices' => ['form.enero' => '01', 'form.febrero' => '02', 'form.marzo' => '03', 'form.abril' => '04', 'form.mayo' => '05', 'form.junio' => '06', 'form.julio' => '07', 'form.agosto' => '08', 'form.septiembre' => '09', 'form.octubre' => '10', 'form.noviembre' => '11', 'form.diciembre' => '12'], 'placeholder' => 'form.seleccione', 'empty_data' => null, 'translation_domain' => 'retencion']);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Retencion::class,

        ]);
    }
}
