<?php

namespace App\Repository;

use App\Entity\Model\Comprobantes;
use App\Entity\Model\GuiaRemision;
use App\Entity\Model\Invoice;
use App\Entity\Model\Liquidacion;
use App\Entity\Model\Ncredito;
use App\Entity\Model\Retencion;
use Doctrine\ORM\QueryBuilder;
use Knp\Component\Pager\PaginatorInterface;

/**
 * CustomerRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ComprobantesRepository extends \Doctrine\ORM\EntityRepository
{
    public function findLike($term, $empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Comprobantes::class, 'c')
            ->where('c.claveAcceso LIKE :name')
            ->andWhere('c.emision = :empresa_id')
            ->orWhere('c.razonSocial LIKE :name')
            ->setParameter('name', '%'. $term .'%')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function countRecibidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(Comprobantes::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }

    public function countInvoiceEmitidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(Invoice::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }

    public function firstProduccion($clasename, $empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c.createdAt')
            ->from($clasename, 'c')
            ->where('c.empresa = :empresa_id')
            ->andWhere('c.ambiente =2')
            ->setParameter('empresa_id', $empresa_id)
            ->orderBy('c.createdAt')
            ->getQuery()
            ->getResult();


        return $result;

    }


    public function countRetencionesEmitidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(Retencion::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }

    public function countLiquidacionEmitidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(Liquidacion::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }

    public function countNcreditosEmitidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(Ncredito::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }

    public function countGuiasEmitidos($empresa_id){

        $result = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('count(c.id) ')
            ->from(GuiaRemision::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleScalarResult();


        return $result;

    }


    public function paginatedSearchInvoices(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('i')
            ->from(Invoice::class, 'i');

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $terms = $qb->expr()->literal("%$value%");
                if (is_numeric($value))
                    $expr = $qb->expr()->like('i.number', $terms);
                else
                    $expr = $qb->expr()->like('i.customer_name', $terms);
                /*$qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('i.username', $terms),
                    $qb->expr()->like('i.name', $terms)
                ));*/
                $qb->andWhere($expr);
            } elseif ($field == 'date_from') {
                $qb->andWhere('i.issue_date >= :date_from');
                $qb->setParameter('date_from', $value);
            } elseif ($field == 'date_to') {
                $qb->andWhere('i.issue_date <= :date_to');
                $qb->setParameter('date_to', $value);
            } elseif ($field == 'status') {
                $autorizado = false;
                if ($value == 'autorizado') {
                    $autorizado = true;
                }
                $qb->andWhere('i.autorizado = :autorizado');
                $qb->setParameter('autorizado', $autorizado);
            } elseif ($field == 'tipo') {
                if ($value == 'I')
                    $qb->andWhere('i.customerId =0  OR i.customerId is null');
                if ($value == 'E')
                    $qb->andWhere('i.customerId > 0');

            } elseif ($field == 'empresas') {
                $qb->andWhere('i.empresa = :empresa');
                $qb->setParameter('empresa', $value);

            }
        }

        //if(0 == sizeof($params)){
        //    $qb->Where(' c. =0 OR c.customerId is null');
        //}

        $qb->orderBy('i.id','DESC');

        $this->addPaginatedSearchSelects($qb);
        //$this->applySearchParamsToQuery($params, $qb);

        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    public function paginatedSearchRetenciones(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('i')
            ->from(Retencion::class, 'i');

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $terms = $qb->expr()->literal("%$value%");
                if (is_numeric($value))
                    $expr = $qb->expr()->like('i.number', $terms);
                else
                    $expr = $qb->expr()->like('i.provider_name', $terms);
                /*$qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('i.username', $terms),
                    $qb->expr()->like('i.name', $terms)
                ));*/
                $qb->andWhere($expr);

            } elseif ($field == 'date_from') {
                $qb->andWhere('i.issue_date >= :date_from');
                $qb->setParameter('date_from', $value);
            } elseif ($field == 'date_to') {
                $qb->andWhere('i.issue_date <= :date_to');
                $qb->setParameter('date_to', $value);
            } elseif ($field == 'status') {
                $autorizado = false;
                if ($value == 'autorizado') {
                    $autorizado = true;
                }
                $qb->andWhere('i.autorizado = :autorizado');
                $qb->setParameter('autorizado', $autorizado);
            }elseif ($field == 'tipo') {
                if ($value == 'I')
                    $qb->andWhere('i.customerId =0  OR i.customerId is null');
                if ($value == 'E')
                    $qb->andWhere('i.customerId > 0');

            }elseif ($field == 'empresas') {
                $qb->andWhere('i.empresa = :empresa');
                $qb->setParameter('empresa', $value);

            }
        }

        //if(0 == sizeof($params)){
        //    $qb->Where(' c. =0 OR c.customerId is null');
        //}

        $qb->orderBy('i.id', 'DESC');

        $this->addPaginatedSearchSelects($qb);
        //$this->applySearchParamsToQuery($params, $qb);

        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    protected function applySearchParamsToQuery(array $params, QueryBuilder $qb)
    {
        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $qb->join('i.series', 's');
                $terms = $qb->expr()->literal("%$value%");
                if ($this->getEntityName() == Invoice::class) {
                    $expr = $qb->expr()->orX(
                        $qb->expr()->like('i.number', $terms),
                        $qb->expr()->like('s.name', $terms),
                        $qb->expr()->like("CONCAT(s.value, i.number)", $terms)
                    );
                }
                else {
                    $expr = $qb->expr()->like('s.name', $terms);
                }

                $qb->andWhere($expr);
            } elseif ($field == 'date_from') {
                $qb->andWhere('i.issue_date >= :date_from');
                $qb->setParameter('date_from', $value);
            } elseif ($field == 'date_to') {
                $qb->andWhere('i.issue_date <= :date_to');
                $qb->setParameter('date_to', $value);
            } elseif ($field == 'status') {
                $autorizado = false;
                if($value == 'autorizado') {
                    $autorizado = true;
                }
                $qb->andWhere('i.autorizado = :autorizado');
                $qb->setParameter('autorizado', $autorizado);
            } elseif ($field == 'customer') {
                $customer = $qb->expr()->literal("%$value%");
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('i.customer_name', $customer),
                    $qb->expr()->like('i.customer_identification', $customer)
                ));
            } elseif ($field == 'series') {
                $qb->andWhere('i.series = :series');
                $qb->setParameter('series', $value);
            } elseif ($field == 'tax') {
                $qb->join('i.items', 'it');
                $qb->join('it.taxes', 'tx');
                $qb->andWhere('tx.id = :tax');
                $qb->setParameter('tax', $value);
            }
        }
    }


    protected function addPaginatedSearchSelects(QueryBuilder $qb)
    {
        // Select everything by default.
        $qb->select('i');
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }


}
